% 8. Napisati MAtLAB program koji eksplicitno zadatu funkciju f tabelira na
% intervalu ciji je levi kraj  tacka a sa korakom h = 1/n, n = 1, 2, ..., m
% koristeci tacno k  cvorova  (vrednosti k i m su prirodni brojevi i zadaje
% ih korisnik). za  svaku  vrendost n program treba da formira odgovarajuci
% Lagranzov  interpolacioni polinom koristeci svih k cvorova, zatim program
% treba da omoguci  izracunavanje priblizne vrednosti funkcije f u proizvo-
% ljnoj tacki x  koriscenjem  dobijenih  polinoma uz  poredjenje  dobijenih
% vrednosti sa tacnom vrednoscu f(x). Graficki prikazati.

% Parametri:
% a - pocetna tacka tabeliranja
% k - broj cvorova koji se koristi za interpolaciju
% m - broj polinoma koji se kreiraju
% x - tacka u kojoj se izracunavaju vrednosti u polinomu
function zadatak8
    a = input('Unesi pocetnu tacku: ');
    k = input('Unesi broj cvorova: ');
    m = input('Unesi m: ');
    x = input('Unesi tacku u kojoj se trazi vrednost: ');

    disp(sprintf('f(%g) = %g', x, f(x)));
    xm = []; ym = []; leg = [];
    for n = 1:m
        for i = 1:k
            xi(i) = a+(i-1)/n;
            yi(i) = f(xi(i));
        end
        l = kreiraj_lagranzov(xi, yi);
        disp(sprintf('Za n = %d vrednost u polinomu je L%d(%g) = %g, a razlika od prave funkcije je %g', n, n, x, polyval(l, x), abs(f(x)-polyval(l, x))));
        xp = xi(1):(xi(k)-xi(1))/1000:xi(k);
        xm = [xm; xp];
        ym = [ym; polyval(l, xp)];
        leg = [leg; sprintf('Korak 1/%02d', n)];
    end
    xp = a:(k-1)/1000:a+k-1;
    xm = [xm; xp];
    ym = [ym; f(xp)];
    leg = [leg; 'f(x)      '];
    plot(xm', ym', '-');
    legend(leg);
    title('Poredjenje tacnosti interpolacija Langrazovim polinomom za drugaciji korak');

function l = kreiraj_lagranzov(xi, yi)
    syms x;

    n = length(xi);
    l = sym('0');
    for i = 1:n
        p = sym('1');
        for j = 1:n
            if (i ~= j)
                p = p * (x-xi(j))/(xi(i)-xi(j));
            end
        end
        l = l + p * yi(i);
    end
    l = sym2poly(l);
